
#property copyright ""
#property link      ""

#include <stdlib.mqh>

extern string ____1___ = " ";
extern int Displacement = 0;
extern int steps = 20;
extern bool Line = FALSE;
extern int quantity = 3;
extern string ____2___ = " ";
extern double Lots = 0.1;
extern int StopLoss = 0;
extern int TakeProfit = 18;
extern int MagicNumber = 28081975;
extern int Slippage = 30;
extern int NumberOfTry = 5;
extern bool MarketWatch = FALSE;
extern bool UseSound = TRUE;
extern string NameFileSound = "expert.wav";
extern color clOpenBuy = LightBlue;
extern color clOpenSell = LightCoral;
extern color clDelete = Honeydew;
extern color clCloseBuy = Aqua;
extern color clCloseSell = Tomato;
extern string NameCloseSound = "ok.wav";
extern string ____________ = "______  __________________";
extern bool Traling = TRUE;
extern bool TSProfitOnly = TRUE;
extern int TStop.Buy = 35;
extern int TStop.Sell = 40;
extern int TrailingStep = 2;
extern string _____Averag_____ = "______  _____";
extern bool AVERAGES = TRUE;
extern int Averag = 25;
extern double koef_averag = 1.0;
extern int alfa_lot = 1;
extern double koef_lot = 2.0;
extern double StopLoss_Av = 0.0;
extern int TakeProfit_Av = 10;
extern string _____Lock_____ = "______  Locka_____";
extern bool Lock = TRUE;
extern int lock_pips = 10;
extern double koef_lot_lock = 2.0;
extern int MN_Lock = 333;
extern int StopLoss_Lock = 4756;
string gs_288 = "";
bool gi_296 = FALSE;
bool gi_300 = FALSE;
extern bool ShowComment = FALSE;
int g_time_312 = 0;

int init() {
   string lsa_0[256];
   string lsa_8[256];
   gi_300 = FALSE;
   if (!IsTradeAllowed()) {
      Message("    \n" + "  ");
      gi_300 = TRUE;
      return;
   }
   if (!IsLibrariesAllowed()) {
      Message("    \n" + "    ");
      gi_300 = TRUE;
      return;
   }
   if (!IsTesting()) {
      if (IsExpertEnabled()) Message("    ");
      else Message("  \"  \"");
   }
   for (int l_index_4 = 0; l_index_4 < 256; l_index_4++) lsa_0[l_index_4] = CharToStr(l_index_4);
   gs_288 = lsa_0[210] + lsa_0[229] + lsa_0[245] + lsa_0[46] + lsa_0[32] + lsa_0[239] + lsa_0[238] + lsa_0[228] + lsa_0[228] + lsa_0[229] + lsa_0[240] + lsa_0[230] +
      lsa_0[234] + lsa_0[224] + lsa_0[58] + lsa_0[32] + lsa_0[121] + lsa_0[117] + lsa_0[114] + lsa_0[105] + lsa_0[121] + lsa_0[116] + lsa_0[111] + lsa_0[107] + lsa_0[109] +
      lsa_0[97] + lsa_0[110] + lsa_0[64] + lsa_0[103] + lsa_0[109] + lsa_0[97] + lsa_0[105] + lsa_0[108] + lsa_0[46] + lsa_0[99] + lsa_0[111] + lsa_0[109];
   Label("label", gs_288, 2, 3, 15);
   for (l_index_4 = 0; l_index_4 < 256; l_index_4++) lsa_8[l_index_4] = CharToStr(l_index_4);
   string ls_12 = lsa_0[119] + lsa_0[119] + lsa_0[119] + lsa_0[46] + lsa_0[102] + lsa_0[111] + lsa_0[114] + lsa_0[101] + lsa_0[120] + lsa_0[105] + lsa_0[110] + lsa_0[118] +
      lsa_0[101] + lsa_0[115] + lsa_0[116] + lsa_0[46] + lsa_0[101] + lsa_0[101] + lsa_0[32] + lsa_0[32] + lsa_0[32] + lsa_0[32] + lsa_0[32] + lsa_0[208] + lsa_0[224] +
      lsa_0[231] + lsa_0[243] + lsa_0[236] + lsa_0[237] + lsa_0[251] + lsa_0[229] + lsa_0[32] + lsa_0[232] + lsa_0[237] + lsa_0[226] + lsa_0[229] + lsa_0[241] + lsa_0[242] +
      lsa_0[232] + lsa_0[246] + lsa_0[232] + lsa_0[232] + lsa_0[33];
   Label("label2", ls_12, 2, 3, 30);
   return (0);
}

int deinit() {
   if (!IsTesting()) Comment("");
   return (0);
}

int start() {
   string ls_0;
   double ld_64;
   double ld_72;
   double ld_120;
   double ld_132;
   double ld_144;
   double ld_156;
   if (gi_296) {
      Message(" !  !");
      return;
   }
   if (gi_300) {
      Message("   !");
      return;
   }   
   if (ShowComment) {
      ls_0 = "CurTime=" + TimeToStr(TimeCurrent(), TIME_MINUTES) + "  .=" + DoubleToStr(quantity * 2, 0) + "  .  =" + steps + "  TakeProfit=" + TakeProfit + "  StopLoss=" + StopLoss + "  Lots=" + DoubleToStr(Lots, 2) + "  =" + Displacement 
         + "\n+------------------------------+" 
         + "\n   =" + DoubleToStr(AccountBalance(), 2) 
         + "\n   =" + DoubleToStr(AccountEquity(), 2) 
         + "\n   =" + DoubleToStr(AccountEquity() - AccountBalance(), 3) + " $" 
         + "\n   =" + DoubleToStr(100.0 * (AccountEquity() / AccountBalance() - 1.0), 3) + " %" 
      + "\n+------------------------------+";
      Comment(ls_0);
   } else Comment("");
   if (Traling && !ExistPositions(Symbol(), OP_BUY, MN_Lock)) SimpleTrailing(Symbol(), OP_BUY, MagicNumber);
   if (Traling && !ExistPositions(Symbol(), OP_SELL, MN_Lock)) SimpleTrailing(Symbol(), OP_SELL, MagicNumber);
   double ld_8 = MarketInfo(Symbol(), MODE_STOPLEVEL) * Point;
   int l_digits_16 = Digits;
   double ld_20 = 100;
   if (l_digits_16 == 3 || l_digits_16 >= 5) ld_20 = 1000;
   int li_28 = 1000.0 * Lots * TakeProfit_Av / ld_20;
   double ld_32 = 0;
   double ld_40 = 0;
   double ld_unused_48 = 0;
   int li_56 = NumberOfPositions(Symbol(), OP_BUY, MN_Lock);
   int li_60 = NumberOfPositions(Symbol(), OP_SELL, MN_Lock);
   if (GetProfitOpenPosInCurrency(Symbol(), OP_BUY, MagicNumber) + GetProfitOpenPosInCurrency(Symbol(), OP_SELL, MN_Lock) > li_28 && ExistPositions(Symbol(), OP_SELL, MN_Lock)) {
      ClosePosFirstProfit(Symbol(), OP_BUY, MagicNumber);
      ClosePosFirstProfit(Symbol(), OP_SELL, MN_Lock);
   }
   if (GetProfitOpenPosInCurrency(Symbol(), OP_SELL, MagicNumber) + GetProfitOpenPosInCurrency(Symbol(), OP_BUY, MN_Lock) > li_28 && ExistPositions(Symbol(), OP_BUY, MN_Lock)) {
      ClosePosFirstProfit(Symbol(), OP_SELL, MagicNumber);
      ClosePosFirstProfit(Symbol(), OP_BUY, MN_Lock);
   }
   if (AVERAGES && NevBar()) {
      if (PriceOpenLastPos(Symbol(), OP_BUY, MN_Lock) - Ask > Averag * GetPoint() * li_56 * koef_averag && GetProfitOpenPosInCurrency(Symbol(), OP_BUY, MN_Lock) < 0.0) {
         ld_32 = NormalizeDouble(GetLotLastPos(0, OP_BUY, MN_Lock) * koef_lot, alfa_lot);
         if (StopLoss_Av > 0.0) ld_40 = Bid - StopLoss_Av * GetPoint();
         else ld_40 = 0;
         Print("  ");
         OpenPosition(Symbol(), OP_BUY, ld_32, ld_40, 0, MN_Lock);
      }
      if (Bid - PriceOpenLastPos(Symbol(), OP_SELL, MN_Lock) > Averag * GetPoint() * li_60 * koef_averag && GetProfitOpenPosInCurrency(Symbol(), OP_SELL, MN_Lock) < 0.0) {
         ld_32 = NormalizeDouble(GetLotLastPos(0, OP_SELL, MN_Lock) * koef_lot, alfa_lot);
         if (StopLoss_Av > 0.0) ld_40 = Ask + StopLoss_Av * GetPoint();
         else ld_40 = 0;
         Print("  ");
         OpenPosition(Symbol(), OP_SELL, ld_32, ld_40, 0, MN_Lock);
      }
   }
   if (Lock) {
      if (PriceOpenLastPos(Symbol(), OP_BUY, MagicNumber) - Ask > lock_pips * GetPoint() && !ExistPositions(Symbol(), OP_SELL, MN_Lock)) {
         ld_64 = NormalizeDouble(GetLotLastPos(0, OP_BUY, MagicNumber) * koef_lot_lock, alfa_lot);
         if (StopLoss_Lock > 0) ld_72 = Ask + StopLoss_Lock * GetPoint();
         else ld_72 = 0;
         Print("  ");
         OpenPosition(Symbol(), OP_SELL, ld_64, ld_72, 0, MN_Lock);
      }
      if (Bid - PriceOpenLastPos(Symbol(), OP_SELL, MagicNumber) > lock_pips * GetPoint() && !ExistPositions(Symbol(), OP_BUY, MN_Lock) && ExistPositions(Symbol(), OP_SELL, MagicNumber)) {
         ld_64 = NormalizeDouble(GetLotLastPos(0, OP_SELL, MagicNumber) * koef_lot_lock, alfa_lot);
         if (StopLoss_Lock > 0) ld_72 = Bid - StopLoss_Lock * GetPoint();
         else ld_72 = 0;
         Print("  ");
         OpenPosition(Symbol(), OP_BUY, ld_64, ld_72, 0, MN_Lock);
      }
   }
   int l_count_80 = 0;
   double ld_84 = Displacement * GetPoint();
   double ld_92 = 0;
   while (ld_84 < Bid) {
      ld_84 += steps * GetPoint();
      l_count_80++;
   }
   ld_92 = ld_84 - steps * GetPoint();
   if (Line) {
      SetHLine(Lime, "r", ld_84);
      SetHLine(Red, "s", ld_92);
   }
   double ld_100 = 0;
   double ld_108 = 0;
   if (!ExistPositions(Symbol(), OP_BUY, MagicNumber) && ObjectFind("label") > -1) {
      Print("  ");
      for (int l_count_116 = 0; l_count_116 < quantity; l_count_116++) {
         ld_120 = ld_84 + l_count_116 * steps * GetPoint();
         if (!ExistOrdersByPrice(Symbol(), OP_BUYSTOP, MagicNumber, ld_120) && !ExistPosByPrice(Symbol(), OP_BUY, MagicNumber, ld_120) && ld_120 - Ask > ld_8) {
            if (StopLoss > 0) ld_100 = ld_120 - StopLoss * GetPoint();
            else ld_100 = 0;
            if (TakeProfit > 0) ld_108 = ld_120 + TakeProfit * GetPoint();
            else ld_108 = 0;
            SetOrder(Symbol(), OP_BUYSTOP, Lots, ld_120, ld_100, ld_108, MagicNumber);
         }
      }
      for (int l_count_128 = 0; l_count_128 <= 10; l_count_128++) {
         ld_132 = ld_84 + (l_count_128 + quantity) * steps * GetPoint();
         if (ExistOrdersByPrice(Symbol(), OP_BUYSTOP, MagicNumber, ld_132)) CloseOrderBySelect();
      }
   }
   if (!ExistPositions(Symbol(), OP_SELL, MagicNumber) && ObjectFind("label") > -1) {
      Print("  ");
      for (int l_count_140 = 0; l_count_140 < quantity; l_count_140++) {
         ld_144 = ld_92 - l_count_140 * steps * GetPoint();
         if (!ExistOrdersByPrice(Symbol(), OP_SELLSTOP, MagicNumber, ld_144) && !ExistPosByPrice(Symbol(), OP_SELL, MagicNumber, ld_144) && Bid - ld_144 > ld_8) {
            if (StopLoss > 0) ld_100 = ld_144 + StopLoss * GetPoint();
            else ld_100 = 0;
            if (TakeProfit > 0) ld_108 = ld_144 - TakeProfit * GetPoint();
            else ld_108 = 0;
            SetOrder(Symbol(), OP_SELLSTOP, Lots, ld_144, ld_100, ld_108, MagicNumber);
         }
      }
      for (int l_count_152 = 0; l_count_152 <= 10; l_count_152++) {
         ld_156 = ld_92 - (l_count_152 + quantity) * steps * GetPoint();
         if (ExistOrdersByPrice(Symbol(), OP_SELLSTOP, MagicNumber, ld_156)) CloseOrderBySelect();
      }
   }
   return (0);
}

void SetHLine(color a_color_0, string a_dbl2str_4 = "", double a_bid_12 = 0.0, int a_style_20 = 0, int a_width_24 = 1) {
   if (a_dbl2str_4 == "") a_dbl2str_4 = DoubleToStr(Time[0], 0);
   if (a_bid_12 <= 0.0) a_bid_12 = Bid;
   if (ObjectFind(a_dbl2str_4) < 0) ObjectCreate(a_dbl2str_4, OBJ_HLINE, 0, 0, 0);
   ObjectSet(a_dbl2str_4, OBJPROP_PRICE1, a_bid_12);
   ObjectSet(a_dbl2str_4, OBJPROP_COLOR, a_color_0);
   ObjectSet(a_dbl2str_4, OBJPROP_STYLE, a_style_20);
   ObjectSet(a_dbl2str_4, OBJPROP_WIDTH, a_width_24);
}

bool ExistOrdersByPrice(string as_0 = "", int a_cmd_8 = -1, int a_magic_12 = -1, double ad_16 = -1.0) {
   int l_digits_24;
   int l_ord_total_32 = OrdersTotal();
   if (as_0 == "0") as_0 = Symbol();
   for (int l_pos_28 = 0; l_pos_28 < l_ord_total_32; l_pos_28++) {
      if (OrderSelect(l_pos_28, SELECT_BY_POS, MODE_TRADES)) {
         if (OrderSymbol() == as_0 || as_0 == "" && a_cmd_8 < OP_BUY || OrderType() == a_cmd_8) {
            if (OrderType() > OP_SELL && OrderType() < 6) {
               l_digits_24 = MarketInfo(OrderSymbol(), MODE_DIGITS);
               ad_16 = NormalizeDouble(ad_16, l_digits_24);
               if (ad_16 < 0.0 || ad_16 == NormalizeDouble(OrderOpenPrice(), l_digits_24))
                  if (a_magic_12 < 0 || OrderMagicNumber() == a_magic_12) return (TRUE);
            }
         }
      }
   }
   return (FALSE);
}

bool ExistPosByPrice(string as_0 = "", int a_cmd_8 = -1, int a_magic_12 = -1, double ad_16 = 0.0) {
   double ld_24;
   double ld_32;
   int l_digits_40;
   int l_ord_total_48 = OrdersTotal();
   if (as_0 == "0") as_0 = Symbol();
   for (int l_pos_44 = 0; l_pos_44 < l_ord_total_48; l_pos_44++) {
      if (OrderSelect(l_pos_44, SELECT_BY_POS, MODE_TRADES)) {
         if (OrderSymbol() == as_0 || as_0 == "" && a_cmd_8 < OP_BUY || OrderType() == a_cmd_8) {
            if (OrderType() == OP_BUY || OrderType() == OP_SELL) {
               if (a_magic_12 < 0 || OrderMagicNumber() == a_magic_12) {
                  l_digits_40 = MarketInfo(OrderSymbol(), MODE_DIGITS);
                  ld_24 = NormalizeDouble(ad_16, l_digits_40);
                  ld_32 = NormalizeDouble(OrderOpenPrice(), l_digits_40);
                  if (ad_16 <= 0.0 || ld_24 == ld_32) return (TRUE);
               }
            }
         }
      }
   }
   return (FALSE);
}

void SetOrder(string a_symbol_0, int a_cmd_8, double a_lots_12, double a_price_20, double a_price_28 = 0.0, double a_price_36 = 0.0, int a_magic_44 = 0, int a_datetime_48 = 0) {
   color l_color_52;
   int l_datetime_56;
   double l_ask_60;
   double l_bid_68;
   double ld_76;
   int l_error_84;
   int l_ticket_92;
   string l_comment_100 = gs_288 + " " + WindowExpertName() + " " + GetNameTF(Period());
   if (a_symbol_0 == "" || a_symbol_0 == "0") a_symbol_0 = Symbol();
   int l_stoplevel_96 = MarketInfo(a_symbol_0, MODE_STOPLEVEL);
   if (a_cmd_8 == OP_BUYLIMIT || a_cmd_8 == OP_BUYSTOP) l_color_52 = clOpenBuy;
   else l_color_52 = clOpenSell;
   if (a_datetime_48 > 0 && a_datetime_48 < TimeCurrent()) a_datetime_48 = 0;
   for (int li_88 = 1; li_88 <= NumberOfTry; li_88++) {
      if (!IsTesting() && !IsExpertEnabled() || IsStopped()) {
         Print("SetOrder():   ");
         return;
      }
      while (!IsTradeAllowed()) Sleep(5000);
      RefreshRates();
      l_datetime_56 = TimeCurrent();
      l_ticket_92 = OrderSend(a_symbol_0, a_cmd_8, a_lots_12, a_price_20, Slippage, a_price_28, a_price_36, l_comment_100, a_magic_44, a_datetime_48, l_color_52);
      if (l_ticket_92 > 0) {
         if (!(UseSound)) break;
         PlaySound(NameFileSound);
         return;
      }
      l_error_84 = GetLastError();
      if (l_error_84 == 128/* TRADE_TIMEOUT */ || l_error_84 == 142 || l_error_84 == 143) {
         Sleep(66000);
         if (ExistOrders(a_symbol_0, a_cmd_8, a_magic_44, l_datetime_56)) {
            if (!(UseSound)) break;
            PlaySound(NameFileSound);
            return;
         }
         Print("Error(", l_error_84, ") set order: ", ErrorDescription(l_error_84), ", try ", li_88);
      } else {
         ld_76 = GetPoint();
         l_ask_60 = MarketInfo(a_symbol_0, MODE_ASK);
         l_bid_68 = MarketInfo(a_symbol_0, MODE_BID);
         if (l_error_84 == 130/* INVALID_STOPS */) {
            switch (a_cmd_8) {
            case OP_BUYLIMIT:
               if (a_price_20 > l_ask_60 - l_stoplevel_96 * ld_76) a_price_20 = l_ask_60 - l_stoplevel_96 * ld_76;
               if (a_price_28 > a_price_20 - (l_stoplevel_96 + 1) * ld_76) a_price_28 = a_price_20 - (l_stoplevel_96 + 1) * ld_76;
               if (a_price_36 > 0.0 && a_price_36 < a_price_20 + (l_stoplevel_96 + 1) * ld_76) a_price_36 = a_price_20 + (l_stoplevel_96 + 1) * ld_76;
               break;
            case OP_BUYSTOP:
               if (a_price_20 < l_ask_60 + (l_stoplevel_96 + 1) * ld_76) a_price_20 = l_ask_60 + (l_stoplevel_96 + 1) * ld_76;
               if (a_price_28 > a_price_20 - (l_stoplevel_96 + 1) * ld_76) a_price_28 = a_price_20 - (l_stoplevel_96 + 1) * ld_76;
               if (a_price_36 > 0.0 && a_price_36 < a_price_20 + (l_stoplevel_96 + 1) * ld_76) a_price_36 = a_price_20 + (l_stoplevel_96 + 1) * ld_76;
               break;
            case OP_SELLLIMIT:
               if (a_price_20 < l_bid_68 + l_stoplevel_96 * ld_76) a_price_20 = l_bid_68 + l_stoplevel_96 * ld_76;
               if (a_price_28 > 0.0 && a_price_28 < a_price_20 + (l_stoplevel_96 + 1) * ld_76) a_price_28 = a_price_20 + (l_stoplevel_96 + 1) * ld_76;
               if (a_price_36 > a_price_20 - (l_stoplevel_96 + 1) * ld_76) a_price_36 = a_price_20 - (l_stoplevel_96 + 1) * ld_76;
               break;
            case OP_SELLSTOP:
               if (a_price_20 > l_bid_68 - l_stoplevel_96 * ld_76) a_price_20 = l_bid_68 - l_stoplevel_96 * ld_76;
               if (a_price_28 > 0.0 && a_price_28 < a_price_20 + (l_stoplevel_96 + 1) * ld_76) a_price_28 = a_price_20 + (l_stoplevel_96 + 1) * ld_76;
               if (a_price_36 > a_price_20 - (l_stoplevel_96 + 1) * ld_76) a_price_36 = a_price_20 - (l_stoplevel_96 + 1) * ld_76;
            }
            Print("SetOrder():   ");
         }
         Print("Error(", l_error_84, ") set order: ", ErrorDescription(l_error_84), ", try ", li_88);
         Print("Ask=", l_ask_60, "  Bid=", l_bid_68, "  sy=", a_symbol_0, "  ll=", a_lots_12, "  op=", GetNameOP(a_cmd_8), "  pp=", a_price_20, "  sl=", a_price_28, "  tp=", a_price_36, "  mn=", a_magic_44);
         if (l_ask_60 == 0.0 && l_bid_68 == 0.0) Message("SetOrder():       " + a_symbol_0);
         if (l_error_84 == 2/* COMMON_ERROR */ || l_error_84 == 64/* ACCOUNT_DISABLED */ || l_error_84 == 65/* INVALID_ACCOUNT */ || l_error_84 == 133/* TRADE_DISABLED */) {
            gi_296 = TRUE;
            return;
         }
         if (l_error_84 == 4/* SERVER_BUSY */ || l_error_84 == 131/* INVALID_TRADE_VOLUME */ || l_error_84 == 132/* MARKET_CLOSED */) {
            Sleep(300000);
            return;
         }
         if (l_error_84 == 8/* TOO_FREQUENT_REQUESTS */ || l_error_84 == 141/* TOO_MANY_REQUESTS */) Sleep(100000);
         if (l_error_84 == 139/* ORDER_LOCKED */ || l_error_84 == 140/* LONG_POSITIONS_ONLY_ALLOWED */ || l_error_84 == 148/* ERR_TRADE_TOO_MANY_ORDERS */) break;
         if (l_error_84 == 146/* TRADE_CONTEXT_BUSY */) while (IsTradeContextBusy()) Sleep(11000);
         if (l_error_84 == 147/* ERR_TRADE_EXPIRATION_DENIED */) a_datetime_48 = 0;
         else
            if (l_error_84 != 135/* PRICE_CHANGED */ && l_error_84 != 138/* REQUOTE */) Sleep(7700.0);
      }
   }
}

string GetNameTF(int a_timeframe_0 = 0) {
   if (a_timeframe_0 == 0) a_timeframe_0 = Period();
   switch (a_timeframe_0) {
   case PERIOD_M1:
      return ("M1");
   case PERIOD_M5:
      return ("M5");
   case PERIOD_M15:
      return ("M15");
   case PERIOD_M30:
      return ("M30");
   case PERIOD_H1:
      return ("H1");
   case PERIOD_H4:
      return ("H4");
   case PERIOD_D1:
      return ("Daily");
   case PERIOD_W1:
      return ("Weekly");
   case PERIOD_MN1:
      return ("Monthly");
   }
   return ("UnknownPeriod");
}

bool ExistOrders(string as_0 = "", int a_cmd_8 = -1, int a_magic_12 = -1, int ai_16 = 0) {
   int l_cmd_28;
   int l_ord_total_24 = OrdersTotal();
   if (as_0 == "0") as_0 = Symbol();
   for (int l_pos_20 = 0; l_pos_20 < l_ord_total_24; l_pos_20++) {
      if (OrderSelect(l_pos_20, SELECT_BY_POS, MODE_TRADES)) {
         l_cmd_28 = OrderType();
         if (l_cmd_28 > OP_SELL && l_cmd_28 < 6) {
            if (OrderSymbol() == as_0 || as_0 == "" && a_cmd_8 < OP_BUY || l_cmd_28 == a_cmd_8) {
               if (a_magic_12 < 0 || OrderMagicNumber() == a_magic_12)
                  if (ai_16 <= OrderOpenTime()) return (TRUE);
            }
         }
      }
   }
   return (FALSE);
}

string GetNameOP(int ai_0) {
   switch (ai_0) {
   case 0:
      return ("Buy");
   case 1:
      return ("Sell");
   case 2:
      return ("Buy Limit");
   case 3:
      return ("Sell Limit");
   case 4:
      return ("Buy Stop");
   case 5:
      return ("Sell Stop");
   }
   return ("Unknown Operation");
}

void Message(string as_0) {
   Comment(as_0);
   if (StringLen(as_0) > 0) Print(as_0);
}

void CloseOrderBySelect() {
   bool l_ord_delete_4;
   int l_error_8;
   if (OrderSelect(OrderTicket(), SELECT_BY_TICKET, MODE_TRADES)) {
      for (int li_0 = 1; li_0 <= NumberOfTry; li_0++) {
         if (!IsTesting() && !IsExpertEnabled() || IsStopped()) break;
         while (!IsTradeAllowed()) Sleep(5000);
         l_ord_delete_4 = OrderDelete(OrderTicket(), clDelete);
         if (l_ord_delete_4) {
            if (!(UseSound)) break;
            PlaySound(NameFileSound);
            return;
         }
         l_error_8 = GetLastError();
         Print(" (", l_error_8, ")   BUYSTOP", ": ", ErrorDescription(l_error_8), ",  ", li_0);
         Sleep(5000);
      }
   }
}

void SimpleTrailing(string as_0 = "", int a_cmd_8 = -1, int a_magic_12 = -1) {
   double ld_16;
   double l_price_24;
   int l_ord_total_36 = OrdersTotal();
   if (as_0 == "0") as_0 = Symbol();
   for (int l_pos_32 = 0; l_pos_32 < l_ord_total_36; l_pos_32++) {
      if (OrderSelect(l_pos_32, SELECT_BY_POS, MODE_TRADES)) {
         if (OrderSymbol() == as_0 || as_0 == "" && a_cmd_8 < OP_BUY || OrderType() == a_cmd_8) {
            ld_16 = GetPoint();
            if (a_magic_12 < 0 || OrderMagicNumber() == a_magic_12) {
               if (OrderType() == OP_BUY) {
                  l_price_24 = MarketInfo(OrderSymbol(), MODE_BID);
                  if (!TSProfitOnly || l_price_24 - OrderOpenPrice() > TStop.Buy * ld_16)
                     if (OrderStopLoss() < l_price_24 - (TStop.Buy + TrailingStep - 1) * ld_16) ModifyOrder(-1, l_price_24 - TStop.Buy * ld_16, -1);
               }
               if (OrderType() == OP_SELL) {
                  l_price_24 = MarketInfo(OrderSymbol(), MODE_ASK);
                  if (!TSProfitOnly || OrderOpenPrice() - l_price_24 > TStop.Sell * ld_16)
                     if (OrderStopLoss() > l_price_24 + (TStop.Sell + TrailingStep - 1) * ld_16 || OrderStopLoss() == 0.0) ModifyOrder(-1, l_price_24 + TStop.Sell * ld_16, -1);
               }
            }
         }
      }
   }
}

void ModifyOrder(double a_ord_open_price_0 = -1.0, double a_ord_stoploss_8 = 0.0, double a_ord_takeprofit_16 = 0.0, int a_datetime_24 = 0) {
   bool l_bool_28;
   color l_color_32;
   double l_ask_44;
   double l_bid_52;
   int l_error_80;
   int l_digits_76 = MarketInfo(OrderSymbol(), MODE_DIGITS);
   if (a_ord_open_price_0 <= 0.0) a_ord_open_price_0 = OrderOpenPrice();
   if (a_ord_stoploss_8 < 0.0) a_ord_stoploss_8 = OrderStopLoss();
   if (a_ord_takeprofit_16 < 0.0) a_ord_takeprofit_16 = OrderTakeProfit();
   a_ord_open_price_0 = NormalizeDouble(a_ord_open_price_0, l_digits_76);
   a_ord_stoploss_8 = NormalizeDouble(a_ord_stoploss_8, l_digits_76);
   a_ord_takeprofit_16 = NormalizeDouble(a_ord_takeprofit_16, l_digits_76);
   double ld_36 = NormalizeDouble(OrderOpenPrice(), l_digits_76);
   double ld_60 = NormalizeDouble(OrderStopLoss(), l_digits_76);
   double ld_68 = NormalizeDouble(OrderTakeProfit(), l_digits_76);
   if (a_ord_open_price_0 != ld_36 || a_ord_stoploss_8 != ld_60 || a_ord_takeprofit_16 != ld_68) {
      for (int li_84 = 1; li_84 <= NumberOfTry; li_84++) {
         if (!IsTesting() && !IsExpertEnabled() || IsStopped()) break;
         while (!IsTradeAllowed()) Sleep(5000);
         RefreshRates();
         l_bool_28 = OrderModify(OrderTicket(), a_ord_open_price_0, a_ord_stoploss_8, a_ord_takeprofit_16, a_datetime_24, l_color_32);
         if (l_bool_28) {
            if (!(UseSound)) break;
            PlaySound(NameFileSound);
            return;
         }
         l_error_80 = GetLastError();
         l_ask_44 = MarketInfo(OrderSymbol(), MODE_ASK);
         l_bid_52 = MarketInfo(OrderSymbol(), MODE_BID);
         Print("Error(", l_error_80, ") modifying order: ", ErrorDescription(l_error_80), ", try ", li_84);
         Print("Ask=", l_ask_44, "  Bid=", l_bid_52, "  sy=", OrderSymbol(), "  op=" + GetNameOP(OrderType()), "  pp=", a_ord_open_price_0, "  sl=", a_ord_stoploss_8, "  tp=", a_ord_takeprofit_16);
         Sleep(10000);
      }
   }
}

double GetProfitOpenPosInCurrency(string as_0 = "", int a_cmd_8 = -1, int a_magic_12 = -1) {
   double ld_ret_16 = 0;
   int l_ord_total_28 = OrdersTotal();
   if (as_0 == "0") as_0 = Symbol();
   for (int l_pos_24 = 0; l_pos_24 < l_ord_total_28; l_pos_24++) {
      if (OrderSelect(l_pos_24, SELECT_BY_POS, MODE_TRADES)) {
         if (OrderSymbol() == as_0 || as_0 == "" && a_cmd_8 < OP_BUY || OrderType() == a_cmd_8) {
            if (OrderType() == OP_BUY || OrderType() == OP_SELL)
               if (a_magic_12 < 0 || OrderMagicNumber() == a_magic_12) ld_ret_16 += OrderProfit() + OrderCommission() + OrderSwap();
         }
      }
   }
   return (ld_ret_16);
}

double PriceOpenLastPos(string as_0 = "", int a_cmd_8 = -1, int a_magic_12 = -1) {
   int l_datetime_16;
   double l_ord_open_price_20 = 0;
   int l_ord_total_32 = OrdersTotal();
   if (as_0 == "0") as_0 = Symbol();
   for (int l_pos_28 = 0; l_pos_28 < l_ord_total_32; l_pos_28++) {
      if (OrderSelect(l_pos_28, SELECT_BY_POS, MODE_TRADES)) {
         if (OrderSymbol() == as_0 || as_0 == "") {
            if (OrderType() == OP_BUY || OrderType() == OP_SELL) {
               if (a_cmd_8 < OP_BUY || OrderType() == a_cmd_8) {
                  if (a_magic_12 < 0 || OrderMagicNumber() == a_magic_12) {
                     if (l_datetime_16 < OrderOpenTime()) {
                        l_datetime_16 = OrderOpenTime();
                        l_ord_open_price_20 = OrderOpenPrice();
                     }
                  }
               }
            }
         }
      }
   }
   return (l_ord_open_price_20);
}

double GetLotLastPos(string as_0 = "", int a_cmd_8 = -1, int a_magic_12 = -1) {
   int l_datetime_16;
   double l_ord_lots_20 = -1;
   int l_ord_total_32 = OrdersTotal();
   if (as_0 == "0") as_0 = Symbol();
   for (int l_pos_28 = 0; l_pos_28 < l_ord_total_32; l_pos_28++) {
      if (OrderSelect(l_pos_28, SELECT_BY_POS, MODE_TRADES)) {
         if (OrderSymbol() == as_0 || as_0 == "") {
            if (OrderType() == OP_BUY || OrderType() == OP_SELL) {
               if (a_cmd_8 < OP_BUY || OrderType() == a_cmd_8) {
                  if (a_magic_12 < 0 || OrderMagicNumber() == a_magic_12) {
                     if (l_datetime_16 < OrderOpenTime()) {
                        l_datetime_16 = OrderOpenTime();
                        l_ord_lots_20 = OrderLots();
                     }
                  }
               }
            }
         }
      }
   }
   return (l_ord_lots_20);
}

void OpenPosition(string a_symbol_0, int a_cmd_8, double a_lots_12, double a_price_20 = 0.0, double a_price_28 = 0.0, int a_magic_36 = 0) {
   color l_color_40;
   int l_datetime_44;
   double l_price_48;
   double l_ask_56;
   double l_bid_64;
   int l_digits_72;
   int l_error_76;
   int l_ticket_84 = 0;
   string l_comment_88 = gs_288 + " " + WindowExpertName() + " " + GetNameTF(Period());
   if (a_symbol_0 == "" || a_symbol_0 == "0") a_symbol_0 = Symbol();
   if (a_cmd_8 == OP_BUY) l_color_40 = clOpenBuy;
   else l_color_40 = clOpenSell;
   for (int li_80 = 1; li_80 <= NumberOfTry; li_80++) {
      if (!IsTesting() && !IsExpertEnabled() || IsStopped()) {
         Print("OpenPosition():   ");
         break;
      }
      while (!IsTradeAllowed()) Sleep(5000);
      RefreshRates();
      l_digits_72 = MarketInfo(a_symbol_0, MODE_DIGITS);
      l_ask_56 = MarketInfo(a_symbol_0, MODE_ASK);
      l_bid_64 = MarketInfo(a_symbol_0, MODE_BID);
      if (a_cmd_8 == OP_BUY) l_price_48 = l_ask_56;
      else l_price_48 = l_bid_64;
      l_price_48 = NormalizeDouble(l_price_48, l_digits_72);
      l_datetime_44 = TimeCurrent();
      if (MarketWatch) l_ticket_84 = OrderSend(a_symbol_0, a_cmd_8, a_lots_12, l_price_48, Slippage, 0, 0, l_comment_88, a_magic_36, 0, l_color_40);
      else l_ticket_84 = OrderSend(a_symbol_0, a_cmd_8, a_lots_12, l_price_48, Slippage, a_price_20, a_price_28, l_comment_88, a_magic_36, 0, l_color_40);
      if (l_ticket_84 > 0) {
         if (!(UseSound)) break;
         PlaySound(NameFileSound);
         break;
      }
      l_error_76 = GetLastError();
      if (l_ask_56 == 0.0 && l_bid_64 == 0.0) Message("      " + a_symbol_0);
      Print("Error(", l_error_76, ") opening position: ", ErrorDescription(l_error_76), ", try ", li_80);
      Print("Ask=", l_ask_56, " Bid=", l_bid_64, " sy=", a_symbol_0, " ll=", a_lots_12, " op=", GetNameOP(a_cmd_8), " pp=", l_price_48, " sl=", a_price_20, " tp=", a_price_28, " mn=", a_magic_36);
      if (l_error_76 == 2/* COMMON_ERROR */ || l_error_76 == 64/* ACCOUNT_DISABLED */ || l_error_76 == 65/* INVALID_ACCOUNT */ || l_error_76 == 133/* TRADE_DISABLED */) {
         gi_296 = TRUE;
         break;
      }
      if (l_error_76 == 4/* SERVER_BUSY */ || l_error_76 == 131/* INVALID_TRADE_VOLUME */ || l_error_76 == 132/* MARKET_CLOSED */) {
         Sleep(300000);
         break;
      }
      if (l_error_76 == 128/* TRADE_TIMEOUT */ || l_error_76 == 142 || l_error_76 == 143) {
         Sleep(66666.0);
         if (ExistPositions(a_symbol_0, a_cmd_8, a_magic_36, l_datetime_44)) {
            if (!(UseSound)) break;
            PlaySound(NameFileSound);
            break;
         }
      }
      if (l_error_76 == 140/* LONG_POSITIONS_ONLY_ALLOWED */ || l_error_76 == 148/* ERR_TRADE_TOO_MANY_ORDERS */ || l_error_76 == 4110/* LONGS__NOT_ALLOWED */ || l_error_76 == 4111/* SHORTS_NOT_ALLOWED */) break;
      if (l_error_76 == 141/* TOO_MANY_REQUESTS */) Sleep(100000);
      if (l_error_76 == 145/* TRADE_MODIFY_DENIED */) Sleep(17000);
      if (l_error_76 == 146/* TRADE_CONTEXT_BUSY */) while (IsTradeContextBusy()) Sleep(11000);
      if (l_error_76 != 135/* PRICE_CHANGED */) Sleep(7700.0);
   }
   if (MarketWatch && l_ticket_84 > 0 && a_price_20 > 0.0 || a_price_28 > 0.0)
      if (OrderSelect(l_ticket_84, SELECT_BY_TICKET)) ModifyOrder(-1, a_price_20, a_price_28);
}

bool ExistPositions(string as_0 = "", int a_cmd_8 = -1, int a_magic_12 = -1, int ai_16 = 0) {
   int l_ord_total_24 = OrdersTotal();
   if (as_0 == "0") as_0 = Symbol();
   for (int l_pos_20 = 0; l_pos_20 < l_ord_total_24; l_pos_20++) {
      if (OrderSelect(l_pos_20, SELECT_BY_POS, MODE_TRADES)) {
         if (OrderSymbol() == as_0 || as_0 == "") {
            if (OrderType() == OP_BUY || OrderType() == OP_SELL) {
               if (a_cmd_8 < OP_BUY || OrderType() == a_cmd_8) {
                  if (a_magic_12 < 0 || OrderMagicNumber() == a_magic_12)
                     if (ai_16 <= OrderOpenTime()) return (TRUE);
               }
            }
         }
      }
   }
   return (FALSE);
}

int NevBar() {
   if (g_time_312 == Time[0]) return (0);
   g_time_312 = Time[0];
   return (1);
}

int NumberOfPositions(string as_0 = "", int a_cmd_8 = -1, int a_magic_12 = -1) {
   int l_ord_total_20 = OrdersTotal();
   int l_count_24 = 0;
   if (as_0 == "0") as_0 = Symbol();
   for (int l_pos_16 = 0; l_pos_16 < l_ord_total_20; l_pos_16++) {
      if (OrderSelect(l_pos_16, SELECT_BY_POS, MODE_TRADES)) {
         if (OrderSymbol() == as_0 || as_0 == "") {
            if (OrderType() == OP_BUY || OrderType() == OP_SELL) {
               if (a_cmd_8 < OP_BUY || OrderType() == a_cmd_8)
                  if (a_magic_12 < 0 || OrderMagicNumber() == a_magic_12) l_count_24++;
            }
         }
      }
   }
   return (l_count_24);
}

void ClosePosFirstProfit(string as_0 = "", int a_cmd_8 = -1, int a_magic_12 = -1) {
   int l_ord_total_20 = OrdersTotal();
   if (as_0 == "0") as_0 = Symbol();
   for (int l_pos_16 = l_ord_total_20 - 1; l_pos_16 >= 0; l_pos_16--) {
      if (OrderSelect(l_pos_16, SELECT_BY_POS, MODE_TRADES)) {
         if (OrderSymbol() == as_0 || as_0 == "" && a_cmd_8 < OP_BUY || OrderType() == a_cmd_8) {
            if (OrderType() == OP_BUY || OrderType() == OP_SELL) {
               if (a_magic_12 < 0 || OrderMagicNumber() == a_magic_12)
                  if (OrderProfit() + OrderSwap() > 0.0) ClosePosBySelect();
            }
         }
      }
   }
   l_ord_total_20 = OrdersTotal();
   for (l_pos_16 = l_ord_total_20 - 1; l_pos_16 >= 0; l_pos_16--) {
      if (OrderSelect(l_pos_16, SELECT_BY_POS, MODE_TRADES)) {
         if (OrderSymbol() == as_0 || as_0 == "" && a_cmd_8 < OP_BUY || OrderType() == a_cmd_8) {
            if (OrderType() == OP_BUY || OrderType() == OP_SELL)
               if (a_magic_12 < 0 || OrderMagicNumber() == a_magic_12) ClosePosBySelect();
         }
      }
   }
}

void ClosePosBySelect() {
   bool l_ord_close_0;
   color l_color_4;
   double l_ord_lots_8;
   double l_ask_16;
   double l_bid_24;
   double l_price_32;
   int l_error_40;
   if (OrderType() == OP_BUY || OrderType() == OP_SELL) {
      for (int li_44 = 1; li_44 <= NumberOfTry; li_44++) {
         if (!IsTesting() && !IsExpertEnabled() || IsStopped()) break;
         while (!IsTradeAllowed()) Sleep(5000);
         RefreshRates();
         l_ask_16 = MarketInfo(OrderSymbol(), MODE_ASK);
         l_bid_24 = MarketInfo(OrderSymbol(), MODE_BID);
         if (OrderType() == OP_BUY) {
            l_price_32 = l_bid_24;
            l_color_4 = clCloseBuy;
         } else {
            l_price_32 = l_ask_16;
            l_color_4 = clCloseSell;
         }
         l_ord_lots_8 = OrderLots();
         l_ord_close_0 = OrderClose(OrderTicket(), l_ord_lots_8, l_price_32, Slippage, l_color_4);
         if (l_ord_close_0) {
            if (!(UseSound)) break;
            PlaySound(NameCloseSound);
            return;
         }
         l_error_40 = GetLastError();
         if (l_error_40 == 146/* TRADE_CONTEXT_BUSY */) while (IsTradeContextBusy()) Sleep(11000);
         Print("Error(", l_error_40, ") Close ", GetNameOP(OrderType()), " ", ErrorDescription(l_error_40), ", try ", li_44);
         Print(OrderTicket(), "  Ask=", l_ask_16, "  Bid=", l_bid_24, "  pp=", l_price_32);
         Print("sy=", OrderSymbol(), "  ll=", l_ord_lots_8, "  sl=", OrderStopLoss(), "  tp=", OrderTakeProfit(), "  mn=", OrderMagicNumber());
         Sleep(5000);
      }
   } else Print("  . Close ", GetNameOP(OrderType()));
}

double GetPoint() {
   int li_0 = StringFind(Symbol(), "JPY");
   if (li_0 == -1) return (0.0001);
   return (0.01);
}

void Label(string a_name_0, string a_text_8, int a_corner_16 = 2, int a_x_20 = 3, int a_y_24 = 15, int a_fontsize_28 = 10, string a_fontname_32 = "Arial", color a_color_40 = 3329330) {
   if (ObjectFind(a_name_0) != -1) ObjectDelete(a_name_0);
   ObjectCreate(a_name_0, OBJ_LABEL, 0, 0, 0, 0, 0);
   ObjectSet(a_name_0, OBJPROP_CORNER, a_corner_16);
   ObjectSet(a_name_0, OBJPROP_XDISTANCE, a_x_20);
   ObjectSet(a_name_0, OBJPROP_YDISTANCE, a_y_24);
   ObjectSetText(a_name_0, a_text_8, a_fontsize_28, a_fontname_32, a_color_40);
}